unit Unit4;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Registry, ExtCtrls;

type
  TConfig_Form = class(TForm)
    GB_RegFile: TGroupBox;
    GB_Warning: TGroupBox;
    LB_01: TLabel;
    LB_02: TLabel;
    LB_07: TLabel;
    LB_08: TLabel;
    LB_09: TLabel;
    LB_10: TLabel;
    LB_11: TLabel;
    LB_05: TLabel;
    LB_06: TLabel;
    LB_03: TLabel;
    LB_04: TLabel;
    LB_12: TLabel;
    LB_13: TLabel;
    LB_14: TLabel;
    BT_Select: TButton;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    BT_Create: TButton;
    GB_Language: TGroupBox;
    BT_Close: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Pan_Eng: TPanel;
    Image1: TImage;
    Pan_Deu: TPanel;
    Image2: TImage;
    ED_RegFile: TEdit;
    CB_Startup: TCheckBox;
    LB_Warning1: TLabel;
    LB_Warning2: TLabel;
    LB_15: TLabel;
    procedure FormShow(Sender: TObject);
    procedure BT_CreateClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BT_SelectClick(Sender: TObject);
    procedure Pan_EngClick(Sender: TObject);
    procedure Pan_DeuClick(Sender: TObject);
    procedure BT_CloseClick(Sender: TObject);
    procedure CB_StartupClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    procedure RedrawInscriptions;
  public
    { Public-Deklarationen }
  end;

var
  Config_Form: TConfig_Form;

implementation

USES Unit1;

{$R *.DFM}


procedure TConfig_Form.FormShow(Sender: TObject);
begin
RedrawInscriptions;
ActiveControl:=BT_Close;
end;


procedure TConfig_Form.BT_CreateClick(Sender: TObject);
VAR filecheck, tempres: BOOLEAN;
    Privs, PrivsOld: _TOKEN_PRIVILEGES;
    pls: INT64;
    lngProcess, lngTokenPrivileges, lngToken, RL: Cardinal;
begin
SaveDialog.InitialDir:=GetCurrentDir;
REPEAT
filecheck:=FALSE;
tempres:=SaveDialog.Execute;
IF (tempres)
 THEN
  IF (FileExists(SaveDialog.FileName))
   THEN
    BEGIN
    filecheck:=DeleteFile (SaveDialog.FileName);
    IF NOT (filecheck)
     THEN
      IF (Language = 1)
       THEN ShowMessage ('Existing file cannot be overwritten, choose another name!')
       ELSE ShowMessage ('Vorhandene Datei kann nicht berschrieben werden, whlen Sie eine andere!');
    END
   ELSE filecheck:=TRUE;
UNTIL ((tempres=FALSE) OR (filecheck=TRUE));
IF ((tempres) AND (filecheck))
 THEN
  BEGIN
  lngProcess:=GetCurrentProcess;
  lngTokenPrivileges:=TOKEN_ADJUST_PRIVILEGES OR TOKEN_QUERY;
  OpenProcessToken (lngProcess , lngTokenPrivileges , lngToken);
  LookupPrivilegeValue (PChar('') , PChar('SeBackupPrivilege') , pls);
  Privs.PrivilegeCount:=1;
  Privs.Privileges[0].Attributes:=SE_PRIVILEGE_ENABLED;
  Privs.Privileges[0].Luid:=pls;
  AdjustTokenPrivileges (lngToken , FALSE , Privs , SizeOf(PrivsOld) , PrivsOld, RL);
  Reg:=TRegistry.Create;
  Reg.RootKey:=Base_Key;
  tempres:=Reg.SaveKey (Base_Path, SaveDialog.FileName);
  IF (tempres)
   THEN
    BEGIN
    Reg.OpenKey (Config_Path, TRUE);
    Reg.WriteString ('OriginalValuesFile', SaveDialog.FileName);
    Unit1.Hive_File:=SaveDialog.FileName;
    IF (Language = 1)
     THEN ShowMessage ('File has been created succesfully.')
     ELSE ShowMessage ('Datei erfolgreich angelegt.');
    END
   ELSE
    IF (Language = 1)
     THEN ShowMessage ('Unable to create file:' + CHR(13) +
                       'An existing file may be write protected or in use by another program,' + CHR(13) +
                       'another program already accesses this part of the registry,' + CHR(13) +
                       'this part of the registry does not exist' + CHR(13) +
                       'or your user possibly does not have the required rights.')
     ELSE ShowMessage ('Kann die Einstellungen nicht bernehmen:'+ CHR(13) +
                       'falls die Datei existiert, ist sie schreibgeschtzt oder wird durch ein anderes Programm benutzt,' + CHR(13) +
                       'ein anderes Programm greift bereits auf diesen Teil der Registry zu,' + CHR(13) +
                       'dieser Teil der Registry existiert nicht,' + CHR(13) +
                       'oder Ihr Benutzer besitzt nicht die erforderlichen Rechte!');
  Reg.Free;
  IF (tempres) THEN ED_RegFile.Text:=Hive_File;
  END;
end;


procedure TConfig_Form.BT_SelectClick(Sender: TObject);
VAR tempres: BOOLEAN;
begin
OpenDialog.InitialDir:=GetCurrentDir;
REPEAT
tempres:=OpenDialog.Execute;
UNTIL ((tempres=FALSE) OR (FileExists(OpenDialog.FileName)));
IF (FileExists(OpenDialog.FileName))
 THEN
  BEGIN
  Reg:=TRegistry.Create;
  Reg.RootKey:=Base_Key;
  Reg.OpenKey (Config_Path, TRUE);
  Reg.WriteString ('OriginalValuesFile', OpenDialog.FileName);
  Reg.Free;
  Unit1.Hive_File:=OpenDialog.FileName;
  ED_RegFile.Text:=Hive_File;
  END;
end;


procedure TConfig_Form.FormClose(Sender: TObject; var Action: TCloseAction);
begin
IF NOT ((Language=1) OR (Language=2))
 THEN
  BEGIN
  Action:=caNone;
  ShowMessage ('You have to select a language first!' + CHR(13) + 'Sie mssen zuerst eine Sprache auswhlen!');
  END
 ELSE
IF (Unit1.Hive_File = '') OR (FileExists(Unit1.Hive_File)= FALSE)
 THEN
  BEGIN
  Action:=caNone;
  IF (Language = 1)
   THEN ShowMessage ('You have to select an existing file or to create one' + CHR(13) +
                     'in order to use the program!')
   ELSE ShowMessage ('Sie mssen eine existierende Datei auswhlen oder eine erstellen,' + CHR(13) +
                     'um das Programm benutzen zu knnen!');
  END
 ELSE Unit1.Haupt_Form.Enabled:=TRUE;
end;


procedure TConfig_Form.Pan_EngClick(Sender: TObject);
begin
Haupt_Form.SetLanguage (1);
RedrawInscriptions;
end;


procedure TConfig_Form.Pan_DeuClick(Sender: TObject);
begin
Haupt_Form.SetLanguage (2);
RedrawInscriptions;
end;


procedure TConfig_Form.BT_CloseClick(Sender: TObject);
begin
Config_Form.Close;
end;


PROCEDURE TConfig_Form.RedrawInscriptions;
BEGIN
IF (Language = 2)
 THEN
  BEGIN
  Config_Form.Caption:='Programm-Konfiguration';
  GB_RegFile.Caption:=' Datei mit den Original-Registry-Einstellungen: ';
  GB_Warning.Caption:=' Warnmeldungen: ';
  BT_Select.Caption:='&Auswhlen';
  BT_Create.Caption:='E&rstellen';
  BT_Close.Caption:='&Schlieen';
  LB_01.Caption:='Erstellen Sie eine Datei mit den Original-Werten aus der Registry oder';
  LB_02.Caption:='geben Sie eine bereits existierende Datei an.';
  LB_03.Caption:='Dies ist ntig, damit Werte, die evtl. gendert werden, zu einem';
  LB_04.Caption:='spteren Zeitpunkt wieder hergestellt werden knnen/verfgbar sind.';
  LB_05.Caption:='Diese Datei braucht normalerweise nur einmal fr jede Treiberversion';
  LB_06.Caption:='erstellt/ausgewhlt zu werden und bleibt danach gespeichert.';
  LB_07.Caption:='WICHTIG:';
  LB_08.Caption:='Wenn Sie diese Datei erstellen wollen, so tun Sie dies, bevor Sie die';
  LB_09.Caption:='Einstellungen modifizieren.';
  LB_10.Caption:='Ansonsten knnen evtl. bereits deaktivierte Frequenzen nicht wieder';
  LB_11.Caption:='aktiviert werden (auch wenn diese zur Auswahl stehen)!';
  LB_12.Caption:='TIP:';
  LB_13.Caption:='Erstellen Sie direkt nach der Installation eines neuen Treibers (und';
  LB_14.Caption:='dem darauf folgenden Neustart) diese Datei.';
  LB_15.Caption:='HINWEIS: Es sind bereits Dateien bei diesem Programm enthalten.';
  LB_Warning1.Caption:='Die folgenden Warnmeldungen';
  LB_Warning2.Caption:='anzeigen:';
  CB_Startup.Caption:='&Programmstart';
  END
 ELSE
  BEGIN
  Config_Form.Caption:='Program configuration';
  GB_RegFile.Caption:=' File containing the original Registry settings: ';
  GB_Warning.Caption:=' Warning messages: ';
  BT_Select.Caption:='&Select';
  BT_Create.Caption:='C&reate';
  BT_Close.Caption:='&Close';
  LB_01.Caption:='Create a file containing the original values from the registry or select';
  LB_02.Caption:='an existing file.';
  LB_03.Caption:='This is necessary for restoring all values/making them available at a';
  LB_04.Caption:='later point.';
  LB_05.Caption:='This file normally needs to be created/selected once for each driver';
  LB_06.Caption:='version and remains selected by this program.';
  LB_07.Caption:='IMPORTANT:';
  LB_08.Caption:='If you want to create this file, then do this before modifying any';
  LB_09.Caption:='values.';
  LB_10.Caption:='Otherwise, eventually deactivated frequencies can not be activated';
  LB_11.Caption:='again (even if shown available for selection)!';
  LB_12.Caption:='HINT:';
  LB_13.Caption:='Create this file directly after the installation of an new driver version';
  LB_14.Caption:='(and the following restart).';
  LB_15.Caption:='NOTE: There have been some files supplied with this program.';
  LB_Warning1.Caption:='Show the following warning';
  LB_Warning2.Caption:='messages:';
  CB_Startup.Caption:='&Program startup';
  END;
IF ((Language=1) OR (Language=2))
 THEN
  BEGIN
  GB_RegFile.Enabled:=TRUE;
  GB_Warning.Enabled:=TRUE;
  BT_Select.Enabled:=TRUE;
  BT_Create.Enabled:=TRUE;
  LB_01.Enabled:=TRUE;
  LB_02.Enabled:=TRUE;
  LB_03.Enabled:=TRUE;
  LB_04.Enabled:=TRUE;
  LB_05.Enabled:=TRUE;
  LB_06.Enabled:=TRUE;
  LB_07.Enabled:=TRUE;
  LB_08.Enabled:=TRUE;
  LB_09.Enabled:=TRUE;
  LB_10.Enabled:=TRUE;
  LB_11.Enabled:=TRUE;
  LB_12.Enabled:=TRUE;
  LB_13.Enabled:=TRUE;
  LB_14.Enabled:=TRUE;
  LB_15.Enabled:=TRUE;
  LB_Warning1.Enabled:=TRUE;
  LB_Warning2.Enabled:=TRUE;
  CB_Startup.Enabled:=TRUE;
  ED_RegFile.Enabled:=TRUE;
  END
 ELSE
  BEGIN
  GB_RegFile.Enabled:=FALSE;
  GB_Warning.Enabled:=FALSE;
  BT_Select.Enabled:=FALSE;
  BT_Create.Enabled:=FALSE;
  LB_01.Enabled:=FALSE;
  LB_02.Enabled:=FALSE;
  LB_03.Enabled:=FALSE;
  LB_04.Enabled:=FALSE;
  LB_05.Enabled:=FALSE;
  LB_06.Enabled:=FALSE;
  LB_07.Enabled:=FALSE;
  LB_08.Enabled:=FALSE;
  LB_09.Enabled:=FALSE;
  LB_10.Enabled:=FALSE;
  LB_11.Enabled:=FALSE;
  LB_12.Enabled:=FALSE;
  LB_13.Enabled:=FALSE;
  LB_14.Enabled:=FALSE;
  LB_15.Enabled:=FALSE;
  LB_Warning1.Enabled:=FALSE;
  LB_Warning2.Enabled:=FALSE;
  CB_Startup.Enabled:=FALSE;
  ED_RegFile.Enabled:=FALSE;
  END;
CB_Startup.Checked:=Warn_Start;
IF (Hive_File = '')
 THEN
  IF (Language=2)
   THEN ED_RegFile.Text:='--- Keine Datei ausgewhlt!!! ---'
   ELSE ED_RegFile.Text:='--- No file selected!!! ---'
 ELSE ED_RegFile.Text:=Hive_File;
IF (Language = 1)
 THEN Pan_Eng.BevelOuter:=bvLowered
 ELSE Pan_Eng.BevelOuter:=bvRaised;
IF (Language = 2)
 THEN Pan_Deu.BevelOuter:=bvLowered
 ELSE Pan_Deu.BevelOuter:=bvRaised;
END;


procedure TConfig_Form.CB_StartupClick(Sender: TObject);
begin
IF NOT (CB_Startup.Checked)
 THEN Haupt_Form.ShowStartMessage;
Warn_Start:=CB_Startup.Checked;
Reg:=TRegistry.Create;
Reg.RootKey:=Base_Key;
Reg.OpenKey (Config_Path , TRUE);
Reg.WriteBool ('WarningStartup' , Warn_Start);
Reg.Free;
end;


procedure TConfig_Form.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
IF NOT (ssCtrl in Shift)
 THEN
  BEGIN
  IF (Key=69) THEN Pan_EngClick (NIL); // "e"
  IF (Key=68) THEN Pan_DeuClick (NIL); // "d"
  END;
IF (Key=VK_ESCAPE) THEN Config_Form.Close;
end;



end.
